﻿IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NB_Personal_PushedEvents')
BEGIN
	-- Creating table 'NB_Personal_PushedEvents'
	CREATE TABLE [dbo].[NB_Personal_PushedEvents] (
		[PrincipalID] int  NOT NULL,
		[ChannelSetID] int  NOT NULL,
		[ChannelID] int  NOT NULL,
		[EventType] int  NOT NULL,
		[Enabled] bit  NOT NULL
	);

	-- Creating table 'NB_Personal_PushedEvent_Defaults'
	CREATE TABLE [dbo].[NB_Personal_PushedEvent_Defaults] (
		[PrincipalID] int  NOT NULL,
		[EventType] int  NOT NULL,
		[Enabled] bit  NOT NULL
	);

	-- Creating primary key on [PrincipalID], [ChannelSetID], [ChannelID], [EventType] in table 'NB_Personal_PushedEvents'
	ALTER TABLE [dbo].[NB_Personal_PushedEvents]
	ADD CONSTRAINT [PK_NB_Personal_PushedEvents]
		PRIMARY KEY CLUSTERED ([PrincipalID], [ChannelSetID], [ChannelID], [EventType] ASC);

	-- Creating primary key on [PrincipalID], [EventType] in table 'NB_Personal_PushedEvent_Defaults'
	ALTER TABLE [dbo].[NB_Personal_PushedEvent_Defaults]
	ADD CONSTRAINT [PK_NB_Personal_PushedEvent_Defaults]
		PRIMARY KEY CLUSTERED ([PrincipalID], [EventType] ASC);

	-- Creating foreign key on [ChannelID] in table 'NB_Personal_PushedEvents'
	ALTER TABLE [dbo].[NB_Personal_PushedEvents]
	ADD CONSTRAINT [FK_NB_Personal_PushedEventNB_Channel]
		FOREIGN KEY ([ChannelID])
		REFERENCES [dbo].[NB_Channel]
			([ChannelID])
		ON DELETE NO ACTION ON UPDATE NO ACTION;

	-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Personal_PushedEventNB_Channel'
	CREATE INDEX [IX_FK_NB_Personal_PushedEventNB_Channel]
	ON [dbo].[NB_Personal_PushedEvents]
		([ChannelID]);

	-- Creating foreign key on [ChannelSetID] in table 'NB_Personal_PushedEvents'
	ALTER TABLE [dbo].[NB_Personal_PushedEvents]
	ADD CONSTRAINT [FK_NB_Personal_PushedEventNB_ChannelSet]
		FOREIGN KEY ([ChannelSetID])
		REFERENCES [dbo].[NB_ChannelSet]
			([ChannelSetID])
		ON DELETE NO ACTION ON UPDATE NO ACTION;

	-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Personal_PushedEventNB_ChannelSet'
	CREATE INDEX [IX_FK_NB_Personal_PushedEventNB_ChannelSet]
	ON [dbo].[NB_Personal_PushedEvents]
		([ChannelSetID]);

	-- Creating foreign key on [PrincipalID] in table 'NB_Personal_PushedEvents'
	ALTER TABLE [dbo].[NB_Personal_PushedEvents]
	ADD CONSTRAINT [FK_NB_Personal_PushedEventPrincipal]
		FOREIGN KEY ([PrincipalID])
		REFERENCES [dbo].[Principal]
			([PrincipalID])
		ON DELETE NO ACTION ON UPDATE NO ACTION;

	-- Creating foreign key on [PrincipalID] in table 'NB_Personal_PushedEvent_Defaults'
	ALTER TABLE [dbo].[NB_Personal_PushedEvent_Defaults]
	ADD CONSTRAINT [FK_NB_Personal_PushedEvent_DefaultPrincipal]
		FOREIGN KEY ([PrincipalID])
		REFERENCES [dbo].[Principal]
			([PrincipalID])
		ON DELETE NO ACTION ON UPDATE NO ACTION;
END;
